/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#if MX_OS_WINNT
#include "getopt.h"
#include <winsock2.h>
#else
#include <unistd.h>
#include <sys/mman.h>
#include <arpa/inet.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "mx__lib_types.h"
#include "mx__fops.h"
#include "mx__driver_interface.h"


void 
usage()
{
  fprintf(stderr, "Usage: mx_dump [args]\n");
  fprintf(stderr, "-b - Board number [0]\n");
  fprintf(stderr, "-h - help\n");
}

int
main(int argc, char *argv[])
{
  mx_endpt_handle_t fd;
  int status;
  mx_crashdump_t dump;
  int numwords, i, board_number;
  uint32_t *words;
  mx_get_board_val_t sram_size, reg_count;
  int c, old_format = 0;
  char *buf;

  board_number = 0;
  
  while ((c = getopt(argc, argv, "hb:")) != EOF) switch(c) {
  case 'b':
    board_number = atoi(optarg);
    break;
  case 'h':
  default:
    usage();
    exit(1);
  }

  mx_init();
  if (mx__open(0, -1, &fd) != MX_SUCCESS) {
    perror("can't open device special file");
    exit(1);
  }

  sram_size.board_number = board_number;
  status = mx__get_sram_size(fd, &sram_size);
  if (status)
    old_format = 1;
  reg_count.board_number = board_number;
  status = mx__get_dump_reg_count(fd, &reg_count);
  if (status && !old_format) {
    printf("failed to determine number of registers to dump\n");
    exit(1);
  } 

  if (old_format) {
    fprintf(stderr, 
	    "mx 1.0.0 driver dump interface detected, winging it\n");
    sram_size.val = 4 * 1024*1024;
    reg_count.val = 0;
  }

  buf = malloc(sram_size.val + reg_count.val * sizeof(uint32_t));
  if (buf == NULL) {
    printf("malloc failed\n");
    exit(1);
  }
  
  memset(&dump, 0, sizeof (dump));
  memset(&buf[0], 0, (size_t)sram_size.val);
  dump.board_number = board_number;
  dump.sram = (uint64_t)(uintptr_t)buf;
  
  status = mx__crashdump(fd, &dump);
  if (status != 0) {
    perror("ioctl failed");
    exit (1);
  }

  words = (unsigned int *)buf;
  if (old_format) {
    printf("%d\n", 1);
    printf("0x1f8 0x%x\n", dump.isr);
  } else {
    printf("%d\n", reg_count.val / 2);
    for (i = 0; i < reg_count.val / 2; i++) {
      printf("0x%x 0x%x\n", words[0], words[1]);
      words+=2;
    }
  }
  numwords = sram_size.val/(sizeof(int));
  printf("0x%x\n", numwords);
  for (i = 0; i < numwords; i++)
    printf("0x%x\n", (unsigned int)ntohl(words[i]));
  return (0);
}

